drop table if exists ens_entrevista_solicitante_empleo;

/*==============================================================*/
/* Table: ens_entrevista_solicitante_empleo                     */
/*==============================================================*/
create table ens_entrevista_solicitante_empleo
(
   ens_id               int not null auto_increment comment 'Llave primaria de entrevistas al solicitante de empleo',
   ens_id_tnv           int not null comment 'Llave primaria - tipo de entrevista',
   ens_id_sle           int(11) not null comment 'Llave principal de Solicitante Empleo',
   ens_fecha            datetime not null comment 'Fecha de entrevista',
   ens_persona_realiza  varchar(300) comment 'Persona que realiza/realizó',
   ens_lugar            varchar(300) comment 'Lugar de realización',
   ens_ponderacion      varchar(300) comment 'ponderación/calificación',
   ens_descripcion      varchar(1000) comment 'Descripción',
   ens_estado           int not null comment 'Estado de registro (1=activo, 0=inactivo)',
   ens_usu_creacion     int not null comment 'auditoria',
   ens_fecha_creacion   datetime not null comment 'auditoria',
   ens_usu_modificacion int not null comment 'auditoria',
   ens_fecha_modificacion datetime not null comment 'auditoria',
   primary key (ens_id)
);

alter table ens_entrevista_solicitante_empleo comment 'Enrevistas realizadas al solicitante de empleo';

alter table ens_entrevista_solicitante_empleo add constraint fk_ens_id_sle foreign key (ens_id_sle)
      references sle_solicitante_empleo (sle_id) on delete restrict on update restrict;

alter table ens_entrevista_solicitante_empleo add constraint fk_ens_id_tnv foreign key (ens_id_tnv)
      references tnv_tipo_entrevista (tnv_id) on delete restrict on update restrict;

drop table if exists enm_entrevista_empleado;

/*==============================================================*/
/* Table: enm_entrevista_empleado                               */
/*==============================================================*/
create table enm_entrevista_empleado
(
   enm_id               int not null auto_increment comment 'Llave primaria de entrevistas al empleado',
   enm_id_emp           int(11) not null comment 'Id de Empleado',
   enm_id_tnv           int not null comment 'Llave primaria - tipo de entrevista',
   enm_fecha            datetime not null comment 'Fecha de entrevista',
   enm_persona_realiza  varchar(300) comment 'Persona que realiza/realizó',
   enm_lugar            varchar(300) comment 'Lugar de realización',
   enm_ponderacion      varchar(300) comment 'ponderación/calificación',
   enm_descripcion      varchar(1000) comment 'Descripción',
   enm_estado           int not null comment 'Estado de registro (1=activo, 0=inactivo)',
   enm_usu_creacion     int not null comment 'auditoria',
   enm_fecha_creacion   datetime not null comment 'auditoria',
   enm_usu_modificacion int not null comment 'auditoria',
   enm_fecha_modificacion datetime not null comment 'auditoria',
   primary key (enm_id)
);

alter table enm_entrevista_empleado comment 'Enrevistas realizadas al empleado';

alter table enm_entrevista_empleado add constraint fk_enm_id_emp foreign key (enm_id_emp)
      references emp_empleado (emp_id) on delete restrict on update restrict;

alter table enm_entrevista_empleado add constraint fk_enm_id_tnv foreign key (enm_id_tnv)
      references tnv_tipo_entrevista (tnv_id) on delete restrict on update restrict;